(function(exports) {
exports.show = function(sensorsId)
{
	if (!$.isEmptyObject(sensorsId))
	{
		let h3 = $(`<h3>`).text(l100n.localize_string("ext_Channels_header"))
		let commands = [{"name": l100n.localize_string("not selected"), "command": "0x0"}]
		sensorsId.forEach(function(id, i) {
			commands.push({"name": id, "command": id})
		});

		let sensors_table = $('<table>');
		let table_head = $('<tr>').addClass('table_header')
		table_head.append($('<td colspan="1">').text(""))
	    table_head.append($('<td colspan="1">').text(l100n.localize_string("ext_Settings")))
		table_head.append($('<td colspan="1">').text(l100n.localize_string("AI Read Float")))
		sensors_table.append(table_head)

		for (let sensor_number = 1; sensor_number <= configuration.one_wire_count; sensor_number++)
		{
			configuration.add_template({"index": `4C08_${sensor_number}`,"template": "combobox", "commands": commands})
			let tr = $('<tr class="can_hide">').append($('<td>').text(`${l100n.localize_string("ext_Channel")} ${sensor_number} `))
			tr.append($('<td>').append($('<div class="sensor_select">').addClass("tag").attr({"index": `4C08:${sensor_number}`})))
			tr.append($('<td>').append($('<div>').addClass("tag").attr({"index": `4C31:${sensor_number}`})))
			sensors_table.append(tr)
		}

		//let sensors_div = $('<div>').addClass("board")		
		let sensors_head = $('<div>').text(l100n.localize_string("1 Wire accordion header")).addClass("accordion-header")
		let sensors_body = $('<div>').append(sensors_table).addClass("accordion-body")
		$("#boyan").append(h3).append(sensors_head).append(sensors_body)
		//$("#io_settings").append(sensors_div)

	}
	//console.log(configuration.data_type_template().templates)
}

exports.request_sensors = function()
{
	let query = '/get_od_data.form?';
	for (let sensor_number = 1; sensor_number <= configuration.one_wire_count; sensor_number++)
	{
		if (sensor_number > 1) { query += "&"; }
		query += `0x4C0A_${sensor_number}`; //sensor ID
	}
	return fetch(query).then(response => response.text())
}
})(this.one_wire = {})